***************************************************************************
Author: L. Pitonakova (http://lenkaspace.net)

License: GNU General Public License. Please credit me when using my work.

This work was funded and delivered in partnership between the Thales Group and the University of Bristol, and with the support of the UK EPSRC Grant Award EP/R004757/1.
***************************************************************************


BUILDING AND RUNNING SIMULATION CODE
=======================================

Built using ARGoS3 version 3.0.0-beta51. Different ARGoS versions may produce compiler errors.
Also requires the QT5 library.

The argos simulation code can be run from the argos directory.
First, invoke cmake with

```
./build.sh -m
```

Build with

```
./build.sh -c
```

A test with visual interface and parameters pre-set can be run as

```
./build.sh -r experiments\[ARGOS_FILE_NAME]
```

The build script includes _setupExperiment.sh which sets default parameter values and sets up the directories and .argos files for a particular experiment. Additionally, build.sh overrides some default parameters.



RUNNING EXPERIMENTS IN BATCH
=======================================
A full set of experiments can be run using one of the runExp_*.sh scripts. These include for loops through different parameter values and multiple experiment runs.
Each run file usually includes experiment type, experimental environment and a parameter shortcut.

The following experiment types have been used:
   
   - "s1_x1": Neural network parameter optimisation data sets
   - "s1_x2": Data sets from experiments in which robot and environment parameters were varied

The following parameter shortcuts have been used:

   - "inw": Number of input weights of clustering layer neurons [1]
   - "at": Activation threshold [1]
   - "ht": Habituation threshold [1]
   - "lr": Neuron learning rate [1]
   - "hut": Habituation update tau [1]
   - "hua": Habituation update alpha [1]
   - "mca": Maximum connection age [1]
   - "unnp": Neighbour neurons update proportionality factor [2]
   - "dishab": Dishabituation of clustering layer neurons turned on [1]
   - "robotSpeed": Maximum robot speed
   - "blobNoize": Standard deviation of the Gaussian noise added to the robot's light blob sensor






References
=================================

[1] Marsland, S., Shapiro, J., & Nehmzow, U. (2002). A self-organising network that grows when required. Neural Networks, 15(8–9), 1041–1058.

[2] Neto, H. V., & Nehmzow, U. (2007). Real-time automated visual inspection using mobile robots. Journal of Intelligent and Robotic Systems, 49(3), 293–307.
