
function prepareDirectory() {
    #-- setup main directory
    EXPERIMENT_DIRECTORY="$DATA_DIRECTORY/$EXPERIMENT_NAME"
	if [ -d $EXPERIMENT_DIRECTORY ]; then
    	echo ""
	else
    	mkdir $EXPERIMENT_DIRECTORY
	fi

	#-- create directory for experiment files
    EXPERIMENT_SUBDIRECTORY="$EXPERIMENT_SUBNAME";
    if [ -d $EXPERIMENT_DIRECTORY/$EXPERIMENT_SUBDIRECTORY ]; then
        echo ""
    else
        mkdir $EXPERIMENT_DIRECTORY/$EXPERIMENT_SUBDIRECTORY;
    fi
}

function prepareArgosFile() {

    #-- create the argos config file
    OUTPUT_FILE_NAME_PREFIX="$EXPERIMENT_DIRECTORY/$EXPERIMENT_SUBDIRECTORY/run$RUN_NO";
    echo "Processing config files for $EXPERIMENT_NAME with $ARGOS_FILE_NAME..."
   
    #-- find the proper library extension based on operating system
    EXTENSION=dylib
    if [[ "$OSTYPE" == "linux-gnu" ]]; then
        EXTENSION=so
    fi
    
    #-- find out if ui should be shown
    if [ $SHOW_UI -eq 1 ] ; then
    	VISUALISATION_NODE_NAME="visualization"
    fi

    #-- patch the argos run file
    sed -e "s^\[OUTPUT_FILE_NAME_PREFIX\]^$OUTPUT_FILE_NAME_PREFIX^g;\
    	s^\[VISUALISATION_NODE_NAME\]^$VISUALISATION_NODE_NAME^g;\
    	s^\[RUN_TIME\]^$RUN_TIME^g;\
    	s^\[RANDOM_SEED\]^$RANDOM_SEED^g;\
    	s^\[ENV_NUM_OF_LEARNING_LOOPS_BEFORE_CHANGE\]^$ENV_NUM_OF_LEARNING_LOOPS_BEFORE_CHANGE^g;\
    	s^\[ROBOT_MAX_SPEED\]^$ROBOT_MAX_SPEED^g;\
    	s^\[ROBOT_BLOB_CAMERA_NOIZE_STD_DEV\]^$ROBOT_BLOB_CAMERA_NOIZE_STD_DEV^g;\
    	s^\[ROBOT_PROXIMITY_SENSOR_NOIZE_STD_DEV\]^$ROBOT_PROXIMITY_SENSOR_NOIZE_STD_DEV^g;\
    	s^\[ROBOT_WHEEL_NOIZE_STD_DEV\]^$ROBOT_WHEEL_NOIZE_STD_DEV^g;\
    	s^\[NN_PRODUCE_LOG_OUTPUT\]^$NN_PRODUCE_LOG_OUTPUT^g;\
    	s^\[NN_INITIAL_NUM_OF_IN_WEIGHTS\]^$NN_INITIAL_NUM_OF_IN_WEIGHTS^g;\
    	s^\[NN_USE_ADAPTIVE_IN_WEIGHT_NUMBER\]^$NN_USE_ADAPTIVE_IN_WEIGHT_NUMBER^g;\
    	s^\[NN_MAX_CONNECTION_AGE\]^$NN_MAX_CONNECTION_AGE^g;\
    	s^\[NN_USE_DISHABITUATION\]^$NN_USE_DISHABITUATION^g;\
    	s^\[NN_ACTIVATION_THRESHOLD\]^$NN_ACTIVATION_THRESHOLD^g;\
    	s^\[NN_HABITUATION_THRESHOLD\]^$NN_HABITUATION_THRESHOLD^g;\
    	s^\[NN_LEARNING_RATE_WINNING_NEURON\]^$NN_LEARNING_RATE_WINNING_NEURON^g;\
    	s^\[NN_HABITUATION_UPDATE_TAU_WINNING_NEURON\]^$NN_HABITUATION_UPDATE_TAU_WINNING_NEURON^g;\
		s^\[NN_HABITUATION_UPDATE_ALPHA\]^$NN_HABITUATION_UPDATE_ALPHA^g;\
    	s^\[NN_UPDATES_NEIGHBOUR_NEURON_PROPORTIONALITY\]^$NN_UPDATES_NEIGHBOUR_NEURON_PROPORTIONALITY^g;\
    	"\
    $ARGOS_FILE_NAME > build/run_temp3.argos
    
    #sed -e '/\[BOX\]/ {' -e 'r experiments/includes/box.xml' -e 'd' -e '}' -i build/run.argos # would require no temp files but doesn't work on MacOS
    sed -e '/\[BOX\]/ {' -e 'r experiments/includes/box.xml' -e 'd' -e '}' build/run_temp3.argos > build/run_temp2.argos
    sed -e '/\[DOOR_WIDER\]/ {' -e 'r experiments/includes/door_wider.xml' -e 'd' -e '}' build/run_temp2.argos > build/run_temp1.argos
    sed -e '/\[DOOR\]/ {' -e 'r experiments/includes/door.xml' -e 'd' -e '}' build/run_temp1.argos > $EXPERIMENT_DIRECTORY/$EXPERIMENT_SUBDIRECTORY/settingsRun$RUN_NO.argos


    rm build/run_temp*
}

function runExperimentTest() {
    prepareDirectory;
    for RUN_NO in `seq 0 0`;
    do
        prepareArgosFile;

        #-- run the experiment in the background
        echo "----- $OUTPUT_FILE_NAME_PREFIX";
        argos3 -c $EXPERIMENT_DIRECTORY/$EXPERIMENT_SUBDIRECTORY/settingsRun$RUN_NO.argos

    done
}


function runExperiment10() {
    prepareDirectory;

    for RUN_NO in `seq 0 9`;
    do
        prepareArgosFile;

        #-- run the experiment in the background
        echo "----- $OUTPUT_FILE_NAME_PREFIX";
        argos3 -c $EXPERIMENT_DIRECTORY/$EXPERIMENT_SUBDIRECTORY/settingsRun$RUN_NO.argos &
        
    	#-- not on iridis, execute 3/4 at a time
        if [ $RUN_NO -eq 2 ] || [ $RUN_NO -eq 5 ] || [ $RUN_NO -eq 9 ] ; then
            wait
        fi
    done
}

function runExperiment50() {
    prepareDirectory;

    for RUN_NO in `seq 0 49`;
    do
        prepareArgosFile;

        #-- run the experiment in the background
        echo "----- $OUTPUT_FILE_NAME_PREFIX";
        argos3 -c $EXPERIMENT_DIRECTORY/$EXPERIMENT_SUBDIRECTORY/settingsRun$RUN_NO.argos &
        
    	#-- not on iridis, execute 3/4 at a time
        if [ $RUN_NO -eq 4 ] || [ $RUN_NO -eq 9 ] || [ $RUN_NO -eq 14 ] || [ $RUN_NO -eq 19 ] || [ $RUN_NO -eq 24 ] || [ $RUN_NO -eq 29 ] || [ $RUN_NO -eq 34 ] || [ $RUN_NO -eq 39 ] || [ $RUN_NO -eq 44 ] || [ $RUN_NO -eq 49 ] ; then
            wait
        fi
    done
}

#==========================================================

#-- default values. NN values in general from Marsland2002 and 2005.
DATA_DIRECTORY="_data";
EXPERIMENT_DIRECTORY="";
EXPERIMENT_SUBDIRECTORY=""
EXPERIMENT_NAME="";
EXPERIMENT_SUBNAME="";
RANDOM_SEED=0;
RUN_NO=0;
RUN_TIME=0; #in seconds rather than loops, 1 second = 10 loops. Use 0 for infinite.

ENV_NUM_OF_LEARNING_LOOPS_BEFORE_CHANGE=1;

ROBOT_MAX_SPEED=20;
ROBOT_BLOB_CAMERA_NOIZE_STD_DEV=0.0;			# camera readings multiplied by gaussian noise
ROBOT_PROXIMITY_SENSOR_NOIZE_STD_DEV=0.0;		# proximity readings multiplied by gaussian noise
ROBOT_WHEEL_NOIZE_STD_DEV=0.0;					# gaussian noize added to each wheel speed

NN_PRODUCE_LOG_OUTPUT="false"

NN_INITIAL_NUM_OF_IN_WEIGHTS=12;
NN_USE_ADAPTIVE_IN_WEIGHT_NUMBER="false"
NN_MAX_CONNECTION_AGE=0;
NN_USE_DISHABITUATION="false"

NN_ACTIVATION_THRESHOLD=0.7;
NN_HABITUATION_THRESHOLD=0.3;

NN_LEARNING_RATE_WINNING_NEURON=0.3;
NN_HABITUATION_UPDATE_TAU_WINNING_NEURON=3.33;
NN_HABITUATION_UPDATE_ALPHA=1.05;
NN_UPDATES_NEIGHBOUR_NEURON_PROPORTIONALITY=0.1;

SHOW_UI=0;
VISUALISATION_NODE_NAME="novisualization";

	







