MY_DIR=`dirname $0`
source $MY_DIR/_setupExperiment.sh

EXPERIMENT_NAME="test";
ENV_NUM_OF_LEARNING_LOOPS_BEFORE_CHANGE=1;
RANDOM_SEED=1;
SHOW_UI=1;
NN_PRODUCE_LOG_OUTPUT="true"

NN_INITIAL_NUM_OF_IN_WEIGHTS=3;
NN_ACTIVATION_THRESHOLD=0.2;
NN_USE_ADAPTIVE_IN_WEIGHT_NUMBER="true"
ROBOT_MAX_SPEED=20

ROBOT_BLOB_CAMERA_NOIZE_STD_DEV=0.0;


function usage() {
    echo ""
    echo "########### Build Script for ARGOS #########"
    echo
    echo "Author: Lenka Pitonakova - contact@lenkaspace.net"
    echo " "
    echo "Usage: ./build.sh -c"
    echo "  Compiles the whole set of files"
    echo "  The output files will be placed in the "$BUILD" directory."
    echo " "
    echo "Additionally, you can use these options: "
    echo "  -r path: Run the experiment with ARGoS 3 simulator"
    echo " "
    echo "Examples:"
    echo "  ./build.sh -c"
    echo "  ./build.sh -r experiments/test.argos"
    echo
    echo "###########################################"
    echo ""
}

function runCmake() {
    echo ""
    echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> Running cmake.."
    if [ -d $BUILD ]; then
        rm -rf $BUILD
    fi
    mkdir $BUILD
    cd $BUILD
    cmake -DCMAKE_BUILD_TYPE=Release ..
    cd ../
}

function compile() {
    echo ""
    echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> Compiling ..."


    #-- compile and build
    cd $BUILD
    make
    cd ../

}


function processConfig() {
    echo "Processing config files for $EXPERIMENT_PATH..."
   
    #-- find the proper library extension based on operating system
    EXTENSION=dylib
    if [[ "$OSTYPE" == "linux-gnu" ]]; then
        EXTENSION=so
    fi

    #-- patch the argos run file
    sed -e "s^\[OUTPUT_FILE_NAME_PREFIX\]^$OUTPUT_FILE_NAME_PREFIX^g"\
    $EXPERIMENT_PATH > build/run_temp3.argos
    
    #sed -e '/\[BOX\]/ {' -e 'r experiments/includes/box.xml' -e 'd' -e '}' -i build/run.argos # would require no temp files but doesn't work on MacOS
    sed -e '/\[BOX\]/ {' -e 'r experiments/includes/box.xml' -e 'd' -e '}' build/run_temp3.argos > build/run_temp2.argos
    sed -e '/\[DOOR_WIDER\]/ {' -e 'r experiments/includes/door_wider.xml' -e 'd' -e '}' build/run_temp2.argos > build/run_temp1.argos
    sed -e '/\[DOOR\]/ {' -e 'r experiments/includes/door.xml' -e 'd' -e '}' build/run_temp1.argos > build/run.argos


    rm build/run_temp*
     
}


function run() {
    runExperimentTest
}

########################################################################

export PKG_CONFIG_PATH=/usr/local/lib/pkgconfig/

declare COMPILE RUN HELP BUILD RUN_PATH RUN_CMAKE DEPLOY REMOTE_LOCATION
declare -a files

RUN=0
HELP=1
COMPILE=0
BUILD="build"
RUN_CMAKE=0
DEPLOY=0
RUN_PATH=""
#OUTPUT_FILE_NAME_PREFIX="test"

#-- check if help should be displayed
while getopts "hr:cmed" name
do
    case $name in
        e)
        BUILD="buildExec"
        HELP=0;;
        h)
        HELP=1;;
        c)
        COMPILE=1
        HELP=0;;
        m)
        RUN_CMAKE=1
        HELP=0;;
        r)
        RUN=1
        HELP=0;
        ARGOS_FILE_NAME="$OPTARG";;
        d)
        DEPLOY=1
        HELP=0;;

        \?) echo "!!! Invalid option: -"$OPTARG"" >&2
        exit 1;;
        : ) echo "!!! Option -"$OPTARG" requires an argument." >&2
        exit 1;;

    esac
done

#echo $RUN_PATH;

if [ $HELP -eq 1 ]; then
    usage;
    exit 1;
fi

#-- compile
if [ $RUN_CMAKE -eq 1 ]; then
    runCmake
fi
if [ $COMPILE -eq 1 ]; then
    compile
fi

#-- deploy
if [ $DEPLOY -eq 1 ]; then
    deploy
fi

#-- exit if not running
if [ $RUN -eq 0 ]; then
    exit 1;
fi

run
