/* ================================================================
 * ================================================================
 *
 * Base world object that can be defined in the ARGoS XML.
 * Makes use of prototype entities.
 * Each world object XML has a type attribute, which is used to
 * instantiate a specific subclass of BaseWorldObject.
 *
 * Author: L. Pitonakova (http://lenkaspace.net)
 * License: GNU General Public License. Please credit me when using my work.
 *
 * ================================================================
 * ================================================================
 */


#ifndef ENTITIES_BASEWORLDOBJECT_H_
#define ENTITIES_BASEWORLDOBJECT_H_

#define WORLD_PADDING 0.5

#include <argos3/plugins/robots/prototype/simulator/prototype_entity.h>
#include "../helpers/logger.h"

using namespace argos;


class BaseWorldObject {
public:

   enum TYPE {
      UNKNOWN = 0,
      GREEN_BOX,
      RED_BOX,
      CLOSED_DOOR,
      OPEN_DOOR
   };

   static TYPE GetTypeByString(std::string typeStr_);


   BaseWorldObject(TYPE type_, CPrototypeEntity* prototypeEntity_, const CVector3* arenaSize_);
   virtual ~BaseWorldObject();

   CVector3 GetPosition() { return prototypeEntity->GetEmbodiedEntity().GetOriginAnchor().Position; }
   void ChangePosition(float deltaX_, float deltaY_);

   TYPE GetType() { return type; }
   std::string GetTypeStr();
   virtual void SetType(TYPE type_) { type = type_; }
   void SetArgosEntity(CPrototypeEntity* prototypeEntity_) { prototypeEntity = prototypeEntity_; }

protected:

   CPrototypeEntity* prototypeEntity;
   TYPE type;
   const CVector3* arenaSize;


};

#endif /* ENTITIES_BASEWORLDOBJECT_H_ */
