/* ================================================================
 * ================================================================
 *
 * Box world object with an LED light on each corner.
 * Different box types are represented by differently colored LEDs.
 * Makes use of prototype entities.
 *
 * Author: L. Pitonakova (http://lenkaspace.net)
 * License: GNU General Public License. Please credit me when using my work.
 *
 * ================================================================
 * ================================================================
 */

#include "box.h"
#include "../helpers/logger.h"

#include <argos3/core/utility/datatypes/color.h>
#include <argos3/plugins/simulator/entities/led_equipped_entity.h>

Box::Box(TYPE type_, CPrototypeEntity* prototypeEntity_, const CVector3* arenaSize_) :
   BaseWorldObject(type_, prototypeEntity_, arenaSize_) {
   Logger::Out("New box created with type " + GetTypeStr());
}

Box::~Box() {

}

/**
 * Set a type, meaning set LEDs to certain colors
 */
void Box::SetType(BaseWorldObject::TYPE type_) {
   BaseWorldObject::SetType(type_);
   //-- set led colors based on type
   int i;
   switch (type_) {
   case TYPE::GREEN_BOX:
      for (i=0; i<=7; i++) {
         prototypeEntity->GetLEDEquippedEntity().SetLEDColor(i,CColor::GREEN);
      }
      break;
   case TYPE::RED_BOX:
      for (i=0; i<=7; i++) {
         prototypeEntity->GetLEDEquippedEntity().SetLEDColor(i,CColor::RED);
      }
      break;
   default:
      for (i=0; i<=7; i++) {
         prototypeEntity->GetLEDEquippedEntity().SetLEDColor(i,CColor::BLACK);
      }
      break;
   }
}

