/* ================================================================
 * ================================================================
 *
 * Door world object with an LED light on each corner.
 * Open door additionally has four LEDs in the middle turned on
 * Makes use of prototype entities.
 *
 * Author: L. Pitonakova (http://lenkaspace.net)
 * License: GNU General Public License. Please credit me when using my work.
 *
 * ================================================================
 * ================================================================
 */

#include "door.h"

#include <argos3/core/utility/datatypes/color.h>
#include <argos3/plugins/simulator/entities/led_equipped_entity.h>

#include "../helpers/logger.h"

Door::Door(TYPE type_, CPrototypeEntity* prototypeEntity_, const CVector3* arenaSize_) :
   BaseWorldObject(type_, prototypeEntity_, arenaSize_) {
   Logger::Out("New door created with type " + GetTypeStr());

}

Door::~Door() {

}

/**
 * Set a type, meaning set LEDs to certain colors
 */
void Door::SetType(BaseWorldObject::TYPE type_) {
   BaseWorldObject::SetType(type_);
   //-- set led colors based on type
   int i;
   switch (type_) {
   case TYPE::CLOSED_DOOR:
      for (i=8; i<=15; i++) {
         prototypeEntity->GetLEDEquippedEntity().SetLEDColor(i,CColor::BLACK);
      }
      break;
   case TYPE::OPEN_DOOR:
      for (i=8; i<=15; i++) {
         prototypeEntity->GetLEDEquippedEntity().SetLEDColor(i,CColor::GREEN);
      }
      break;
   default:
      break;
   }


}

