/* ================================================================
 * ================================================================
 *
 * A waypoint world object that robots use to navigate.
 * Waypoints are defined in the ARGoS XML file.
 *
 * Author: L. Pitonakova (http://lenkaspace.net)
 * License: GNU General Public License. Please credit me when using my work.
 *
 * ================================================================
 * ================================================================
 */

#ifndef ENTITIES_WAYPOINT_H_
#define ENTITIES_WAYPOINT_H_

#include <argos3/core/utility/math/vector3.h>

using namespace argos;

#define WAYPOINT_GROUND_COLOR 0.6
#define WAYPOINT_INVALID_ORIENTATION 99999
#define WAYPOINT_END_LOOP_ID "endLoop"

struct Waypoint {

   enum TYPE {
      NORMAL = 0,          // the robot will navigate towards it
      INSTANT              // the robot will teleport to it, retaining its orientation
   };

   std::string id;
   CVector3 position;
   Waypoint* nextWaypoint;

   int robotId;
   Waypoint::TYPE type;
   float robotOrientation;

   Waypoint(std::string id_, double x_, double y_, int robotId_, Waypoint::TYPE type_, float robotOrientation_) {
      position = CVector3(x_,y_,0);
      robotId = robotId_;
      nextWaypoint = NULL;
      type = type_;
      id = id_;
      robotOrientation = robotOrientation_;
   }

   Waypoint(const Waypoint& waypoint_) {
      position = CVector3(waypoint_.position.GetX(), waypoint_.position.GetY(),0);
      robotId = waypoint_.robotId;
      nextWaypoint = NULL;
      type = waypoint_.type;
      id = waypoint_.id;
      robotOrientation = waypoint_.robotOrientation;
   }

   CVector2 GetPosition2D() { return CVector2(position.GetX(), position.GetY()); }
};


#endif /* ENTITIES_WAYPOINT_H_ */
