/* ================================================================
 * ================================================================
 *
 * Various helper functions for string and vector manipulation
 *
 * Author: L. Pitonakova (http://lenkaspace.net)
 * License: GNU General Public License. Please credit me when using my work.
 *
 * ================================================================
 * ================================================================
 */

#ifndef HELPERS_HELPERS_H_
#define HELPERS_HELPERS_H_


#include <vector>
#include <argos3/core/utility/logging/argos_log.h>
#include <argos3/core/utility/math/rng.h>
#include <argos3/core/utility/math/vector2.h>

using namespace argos;

class Helpers {
public:

   /** SINGLETON STUFF **/
   static Helpers& GetInstance() {
      static Helpers instance;
      return instance;
   }
   CRandom::CRNG* randNumGenerator;
   /**     --          **/

   static float GetRandomFloat(float min_, float max_);
   static float GetRandomGaussian(float stdDev_);

   static std::string FloatToString(float number_, int precision_ = 2);
   static std::string GetNumberlessString(const std::string& inString_);

   static float GetVectorDistance(const std::vector<float>& vec1_, const std::vector<float>& vec2_);
   static CVector2 ConvertVectorToLocalCoordinateSystem(const CVector2& vector_, double anchorGlobalRotation_);
   static CVector2 GetRelativeVectorFromAnchor(const CVector2& anchorGlobalPosition_, double anchorGlobalRotation_, const CVector2& targetGlobalPosition_);



private:
   /** SINGLETON STUFF **/
   Helpers() {
      randNumGenerator = CRandom::CreateRNG("argos");
   }
   Helpers(Helpers const&);
   void operator=(Helpers const&);

   /**     --          **/


};

#endif /* HELPERS_HELPERS_H_ */
