/* ================================================================
 * ================================================================
 *
 * Various logging functions.
 * Statis functions for general logging on screen.
 * Member functions for logging into a single log file. To be used with
 * a singleton instance of Logger.
 *
 * Author: L. Pitonakova (http://lenkaspace.net)
 * License: GNU General Public License. Please credit me when using my work.
 *
 * ================================================================
 * ================================================================
 */

#include "logger.h"
#include <argos3/core/utility/logging/argos_log.h>

static std::string outEnvironmentStr = "";

/* ====================================================================
 *                              SINGLETON STUFF
 * ==================================================================== */

Logger* Logger::instance = 0;

/**
 * Return Singleton instance of Logger
 */
Logger* Logger::Instance() {
    if (instance == 0) {
        instance = new Logger();
    }
    return instance;
}

/**
 * Deletes the singleton instance, if any
 */
void Logger::DeleteInstance() {
    if (instance != 0) {
        delete instance;
        instance = NULL;
    }
}

/* ====================================================================
 *                              INIT / DESTROY
 * ==================================================================== */
Logger::Logger() {
   currentSimulationTime = 0;
}

Logger::~Logger() {

}

/**
 * Open all output files for writing, prefixing their file names with outputFileNamePrefix_
 */
void Logger::OpenOutputFiles(string outputFileNamePrefix_) {
   ostringstream fileNameEvents;
   fileNameEvents << outputFileNamePrefix_ << "_events.txt";
   outputFileEvents.open(fileNameEvents.str(), std::ios_base::trunc | std::ios_base::out);
   outputFileEvents << "time\tevtType\tobjectId\tvar1\tvar2\tvar3\tvar4" << std::endl;

}

/**
 * Close all output files
 */
void Logger::CloseOutputFiles() {
   outputFileEvents.close();
}


/* ====================================================================
 *                              EVENT LOGGING
 * ==================================================================== */

/**
 * Log an event into the events output file
 */
void Logger::LogEvent(Event::TYPE eventType_, int objectId_, float var1_, float var2_) {
   LogEvent(eventType_,objectId_,var1_,var2_,-1);

}

/**
 * Log an event into the events output file
 */
void Logger::LogEvent(Event::TYPE eventType_, int objectId_, float var1_, float var2_, float var3_) {
   outputFileEvents << currentSimulationTime << "\t"
            << eventType_ << "\t"
            << objectId_ << "\t"
            << var1_ << "\t"
            << var2_ << "\t"
            << var3_ << "\t"
            << endl;
}

/**
 * Log an event into the events output file
 */
void Logger::LogEvent(Event::TYPE eventType_, int objectId_, float var1_, float var2_, std::string var3_) {
   outputFileEvents << currentSimulationTime << "\t"
            << eventType_ << "\t"
            << objectId_ << "\t"
            << var1_ << "\t"
            << var2_ << "\t"
            << var3_ << "\t"
            << endl;
}

/* ====================================================================
 *                              OUTPUTS
 * ==================================================================== */

/**
 * Output using ARGoS LOG
 */
void Logger::Out(std::string message_, bool endLine_) {
   argos::LOG << message_;
   if (endLine_) {
      argos::LOG << std::endl;
   }
}

/**
 * Output using ARGoS LOGERR
 */
void Logger::OutErr(std::string message_, bool endLine_) {
   argos::LOGERR << message_ << std::endl;
   if (endLine_) {
      argos::LOG << std::endl;
   }
}

/**
 * Output using ARGoS LOGERR
 */
void Logger::Out(std::string message_, const std::vector<float>& vector_) {
   argos::LOGERR << message_ << " ";
   for(size_t i = 0; i < vector_.size(); i++) {
      argos::LOGERR << vector_[i] << " ";
   }
   argos::LOGERR << std::endl;
}


/**
 * Store output that goes into the overlay on screen (see also loop_functions/qtLoopFunctions.h)
 */
void Logger::OutEnvironment(std::string message_) {
   outEnvironmentStr = message_;
}

/**
 * Return the output that goes into the overlay on screen (see also loop_functions/qtLoopFunctions.h)
 */
string Logger::GetOutEnvironmentStr() {
   return outEnvironmentStr;
}







