/* ================================================================
 * ================================================================
 *
 * Various logging functions.
 * Statis functions for general logging on screen.
 * Member functions for logging into a single log file. To be used with
 * a singleton instance of Logger.
 *
 * Author: L. Pitonakova (http://lenkaspace.net)
 * License: GNU General Public License. Please credit me when using my work.
 *
 * ================================================================
 * ================================================================
 */

#ifndef HELPERS_LOGGER_H_
#define HELPERS_LOGGER_H_

#include <argos3/core/simulator/loop_functions.h>
#include "../../cppCommon/event.h"

using namespace std;

class Logger {

public:
   enum MSGTYPE {
      INFO = 0,
      ERROR
   };


   static Logger* Instance();
   static void DeleteInstance();

   static void Out(string message_, bool endLine_ = true);
   static void OutErr(string message_, bool endLine_ = true);
   static void Out(string message_, const vector<float>& vector_);

   static void OutEnvironment(string message_);
   static string GetOutEnvironmentStr();


   Logger();
   virtual ~Logger();

   void SetCurrentSimulationTime(int time_) { currentSimulationTime = time_; }
   void OpenOutputFiles(string outputFileNamePrefix_);
   void CloseOutputFiles();
   void LogEvent(Event::TYPE eventType_, int objectId_, float var1_, float var2_);
   void LogEvent(Event::TYPE eventType_, int objectId_, float var1_, float var2_, float var3_);
   void LogEvent(Event::TYPE eventType_, int objectId_, float var1_, float var2_, std::string var3_);


private:
   static Logger* instance;

   ofstream outputFileEvents;
   int currentSimulationTime;

};

#endif /* HELPERS_LOGGER_H_ */
