/* ================================================================
 * ================================================================
 *
 * Base class for representing the environment.
 * Includes functions such as ARGoS XML file parsing, object instantiation,
 * scene initialisation, logging.
 *
 * Author: L. Pitonakova (http://lenkaspace.net)
 * License: GNU General Public License. Please credit me when using my work.
 *
 * ================================================================
 * ================================================================
 */

#ifndef LOOP_FUNCTIONS_BASE_ENVIRONMENT_H
#define LOOP_FUNCTIONS_BASE_ENVIRONMENT_H


#include <argos3/core/simulator/loop_functions.h>
#include <argos3/core/simulator/entity/floor_entity.h>
#include <argos3/core/utility/math/range.h>
#include <argos3/core/utility/math/rng.h>
#include <argos3/plugins/simulator/entities/cylinder_entity.h>

#include <argos3/plugins/simulator/entities/box_entity.h>
#include <argos3/plugins/robots/foot-bot/simulator/footbot_entity.h>
#include <argos3/plugins/simulator/entities/light_entity.h>

using namespace argos;

#include "../entities/baseWorldObject.h"
#include "../entities/waypoint.h"



class BaseRobot;

class BaseEnvironment : public CLoopFunctions {

public:


   BaseEnvironment();
   virtual ~BaseEnvironment() {}

   virtual void Init(TConfigurationNode& xmlNode_);
   virtual void Reset();
   virtual void Destroy();
   virtual CColor GetFloorColor(const CVector2& c_position_on_plane);
   virtual void PreStep();


   BaseRobot& GetRobotById(const int& id_);
   void GetWorldObjectIdAndType(ticpp::Element* node_, std::string& id_, std::string& type_);

protected:
   virtual void SetupParameters(TConfigurationNode& xmlNode_);
   virtual void OnNewRun();
   virtual void OnFirstPreStep() { }; // use this to move objects etc., can't be done in init for some reason
   void CreateWorldObject(BaseWorldObject::TYPE type_, CPrototypeEntity* prototypeEntity_);

   //-- events
   virtual void OnRobotAtCurrentWaypoint(CFootBotEntity& robotEntity_, BaseRobot& robotController_, Waypoint* currentWp_);
   virtual void OnRobotFirstTimeAtCurrentWaypoint(CFootBotEntity& robotEntity_, BaseRobot& robotController_, Waypoint* currentWp_);

   //-- output
   std::ofstream outputFileRobotsLog;

   //-- attributes
   std::map<std::string, std::string> idsToObjectTypes;
   std::vector<Waypoint> waypoints;
   std::vector<BaseWorldObject*> worldObjects;

   int numOfRobots;
   bool didHandleFirstPreStep;
   std::vector<CVector3> lastRobotWaypointPosition;

   //-- parameters
   std::string param_outputFileNamePrefix;


};


#endif
