/* ================================================================
 * ================================================================
 *
 * Represents the Corridor environment modelled based on
 * Marsland, S., Nehmzow, U., & Shapiro, J. (2005). On-line novelty detection for autonomous mobile robots. Robotics and Autonomous Systems, 51(2–3), 191–206.
 *
 * The environment contains walls and closed doors (see entities/door.h).
 * Door and light positions are randomised when the simulation starts.
 * After the robot traversed the corridor N times, a random door is opened.
 *
 * Author: L. Pitonakova (http://lenkaspace.net)
 * License: GNU General Public License. Please credit me when using my work.
 *
 * ================================================================
 * ================================================================
 */

#ifndef LOOP_FUNCTIONS_CORRIDORENVIRONMENT_H_
#define LOOP_FUNCTIONS_CORRIDORENVIRONMENT_H_

#include "baseEnvironment.h"

using namespace argos;

class CorridorEnvironment : public BaseEnvironment {
public:
   CorridorEnvironment();
   virtual ~CorridorEnvironment();

protected:
   void SetupParameters(TConfigurationNode& xmlNode_);
   void OnFirstPreStep();
   void OnRobotFirstTimeAtCurrentWaypoint(CFootBotEntity& robotEntity_, BaseRobot& robotController_, Waypoint* currentWp_);

   int robotLearningLoopsCounter;
   int param_numOfLearningLoopsBeforeChange;
   int doorToOpen;

};

#endif /* LOOP_FUNCTIONS_CORRIDORENVIRONMENT_H_ */
