/* ================================================================
 * ================================================================
 *
 * Special rendering functionality, such showing of a robot's next target
 * and providing an information overlay text.
 *
 * Author: L. Pitonakova (http://lenkaspace.net)
 * License: GNU General Public License. Please credit me when using my work.
 *
 * ================================================================
 * ================================================================
 */

#include "qtLoopFunctions.h"
#include "../controllers/baseRobot.h"
#include "../entities/waypoint.h"


#include <argos3/core/simulator/entity/controllable_entity.h>
#include <argos3/core/utility/math/angles.h>
#include <helpers/helpers.h>

#include <QPainter>
#include <QString>
#include <QColor>
#include <QRect>
#include "baseEnvironment.h"

using namespace argos;


QTLoopFunctions::QTLoopFunctions() {
   RegisterUserFunction<QTLoopFunctions,CFootBotEntity>(&QTLoopFunctions::Draw);


}



/**
 * Draw in the world - called for each robot entity
 */
void QTLoopFunctions::Draw(CFootBotEntity& c_entity) {
	BaseRobot& footBot = dynamic_cast<BaseRobot&>(c_entity.GetControllableEntity().GetController());

	//-- draw planned waypoints
	if (GetSelectedEntity() != NULL && GetSelectedEntity()->GetId() == c_entity.GetId()) {
      bool currentWaypointFound = false;
      CVector2 relLocation, relLocationB;
      std::vector<Waypoint*>& wps = *footBot.GetWaypoints();
      for (int i=0; i<footBot.GetWaypoints()->size(); i++) {
         //-- display the current waypoint
         if (wps[i] == footBot.GetCurrentWaypoint()) {
            CVector2 relLocation = Helpers::GetRelativeVectorFromAnchor(footBot.GetPositionTruth2D(), footBot.GetRotationTruth().GetValue(), wps[i]->GetPosition2D());
            DrawRay(CRay3(CVector3::ZERO, CVector3(relLocation.GetY(), -relLocation.GetX(),0)), CColor::BLACK,10.0);
            currentWaypointFound = true;
         } else {
            //-- display other waypoints after the current one
            if (currentWaypointFound) {
               relLocation = Helpers::GetRelativeVectorFromAnchor(footBot.GetPositionTruth2D(), footBot.GetRotationTruth().GetValue(), wps[i-1]->GetPosition2D());
               relLocationB = Helpers::GetRelativeVectorFromAnchor(footBot.GetPositionTruth2D(), footBot.GetRotationTruth().GetValue(), wps[i]->GetPosition2D());
               DrawRay(CRay3(CVector3(relLocation.GetY(), -relLocation.GetX(),0), CVector3(relLocationB.GetY(), -relLocationB.GetX(),0)), CColor::GRAY50,10.0);

            }
         }
      }

      //-- draw direction where robot is pointing towards
      DrawRay(CRay3(CVector3::ZERO, CVector3(0.2,0,0)), CColor::BLUE,20.0);
	}
}

/**
 * Draw on top of the OpenGL window - called once
 */
void QTLoopFunctions::DrawOverlay(QPainter& c_painter) {

   //-- display selected robot info
   CEntity* selectedEntity = GetSelectedEntity();
   if (selectedEntity != NULL) {
      try {
         CFootBotEntity& selectedFootbot = dynamic_cast<CFootBotEntity&>(*selectedEntity);
         BaseRobot& footBot = dynamic_cast<BaseRobot&>(selectedFootbot.GetControllableEntity().GetController());

         //-- a robot is selected - display its info
         c_painter.fillRect(5,5,200,60,QColor(255,255,255,200));
         c_painter.drawText(QRect(10,10,200,60), Qt::AlignLeft, footBot.GetOnScreenDebugString().c_str());

      } catch (...) {
         //-- generic exception - a robot is not selected
      }
   }

   //-- display global state output
   c_painter.fillRect(245,5,200,60,QColor(255,255,255,200));
   c_painter.drawText(QRect(250,10,200,60), Qt::AlignLeft, Logger::GetOutEnvironmentStr().c_str());
}


/* ==================================================================================== */
/* ========================= Register with ARGoS */
/* ==================================================================================== */

REGISTER_QTOPENGL_USER_FUNCTIONS(QTLoopFunctions, "qtLoopFunctions")
