/* ================================================================
 * ================================================================
 *
 * Represents the Room environment modelled based on
 * Neto, H. V., & Nehmzow, U. (2007). Real-time automated visual inspection using mobile robots. Journal of Intelligent and Robotic Systems, 49(3), 293–307.
 *
 * The environment contains walls around and in the middle.
 * Wall light positions are randomised when the simulation starts.
 * After the robot traversed the room N times, a box is placed in a random corner of the room.
 *
 * Author: L. Pitonakova (http://lenkaspace.net)
 * License: GNU General Public License. Please credit me when using my work.
 *
 * ================================================================
 * ================================================================
 */

#ifndef LOOP_FUNCTIONS_ROOMENVIRONMENT_H_
#define LOOP_FUNCTIONS_ROOMENVIRONMENT_H_

#include "baseEnvironment.h"

using namespace argos;

class RoomEnvironment : public BaseEnvironment {
public:
   RoomEnvironment();
   virtual ~RoomEnvironment();


protected:
   void SetupParameters(TConfigurationNode& xmlNode_);
   void OnFirstPreStep();
   void OnRobotFirstTimeAtCurrentWaypoint(CFootBotEntity& robotEntity_, BaseRobot& robotController_, Waypoint* currentWp_);

   int robotLearningLoopsCounter;
   int param_numOfLearningLoopsBeforeChange;
   bool moveDone;
};

#endif /* LOOP_FUNCTIONS_ROOMENVIRONMENT_H_ */
