MY_DIR=`dirname $0`

source $MY_DIR/_setupExperiment.sh
EXPERIMENT_NAME="s1_x1_corridor";
ARGOS_FILE_NAME="experiments/s1_corridor.argos";
ENV_NUM_OF_LEARNING_LOOPS_BEFORE_CHANGE=20;
RUN_TIME=2000;	# 1 run through the corridor is approx. 50s -> leave 20 runs to stabilise, then do another 20 runs so total is 40*50


echo ""
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> EXPERIMENT $EXPERIMENT_NAME STARTED "

#---- best performing from input weights vs activation threshold experiment:
NN_HABITUATION_THRESHOLD=0.3;
NN_LEARNING_RATE_WINNING_NEURON=0.3;
NN_HABITUATION_UPDATE_TAU_WINNING_NEURON=3.33;
NN_HABITUATION_UPDATE_ALPHA=1.05;

NN_USE_DISHABITUATION="true"



NN_INITIAL_NUM_OF_IN_WEIGHTS=12
NN_ACTIVATION_THRESHOLD=0.8

for NN_UPDATES_NEIGHBOUR_NEURON_PROPORTIONALITY in 0.000 0.001 0.002 0.003 0.004 0.005 0.007 0.010 0.050 0.100 0.150
do
	EXPERIMENT_SUBNAME="inw${NN_INITIAL_NUM_OF_IN_WEIGHTS}_at${NN_ACTIVATION_THRESHOLD}_dishab_unnp${NN_UPDATES_NEIGHBOUR_NEURON_PROPORTIONALITY}"
	runExperiment50
done

#----
NN_INITIAL_NUM_OF_IN_WEIGHTS=39
NN_ACTIVATION_THRESHOLD=0.2

for NN_UPDATES_NEIGHBOUR_NEURON_PROPORTIONALITY in 0.000 0.001 0.002 0.003 0.004 0.005 0.007 0.010 0.050 0.100 0.150
do
	EXPERIMENT_SUBNAME="inw${NN_INITIAL_NUM_OF_IN_WEIGHTS}_at${NN_ACTIVATION_THRESHOLD}_dishab_unnp${NN_UPDATES_NEIGHBOUR_NEURON_PROPORTIONALITY}"
	runExperiment50
done

#---- adaptive inw, best performing
NN_INITIAL_NUM_OF_IN_WEIGHTS=3;
NN_USE_ADAPTIVE_IN_WEIGHT_NUMBER="true";
NN_ACTIVATION_THRESHOLD=0.2

for NN_UPDATES_NEIGHBOUR_NEURON_PROPORTIONALITY in 0.000 0.001 0.002 0.003 0.004 0.005 0.007 0.010 0.050 0.100 0.150
do
	EXPERIMENT_SUBNAME="inwAdaptive_at${NN_ACTIVATION_THRESHOLD}_dishab_unnp${NN_UPDATES_NEIGHBOUR_NEURON_PROPORTIONALITY}"
	runExperiment50
done

NN_USE_ADAPTIVE_IN_WEIGHT_NUMBER="false";


echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> EXPERIMENT $EXPERIMENT_NAME ENDED "
echo ""
