MY_DIR=`dirname $0`

source $MY_DIR/_setupExperiment.sh
EXPERIMENT_NAME="s1_x1_corridor";
ARGOS_FILE_NAME="experiments/s1_corridor.argos";
ENV_NUM_OF_LEARNING_LOOPS_BEFORE_CHANGE=20;
RUN_TIME=2000;	# 1 run through the corridor is approx. 50s -> leave 20 runs to stabilise, then do another 20 runs so total is 40*50


echo ""
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> EXPERIMENT $EXPERIMENT_NAME STARTED "

#---- best performing from input weights vs activation threshold experiment:
NN_INITIAL_NUM_OF_IN_WEIGHTS=12
NN_ACTIVATION_THRESHOLD=0.8
NN_HABITUATION_THRESHOLD=0.3;
NN_LEARNING_RATE_WINNING_NEURON=0.3;

for NN_HABITUATION_UPDATE_TAU_WINNING_NEURON in 0.66 1.33 2.00 2.66 3.33 4.00 5.00 7.00 9.00
do
	for NN_HABITUATION_UPDATE_ALPHA in 0.90 1.00 1.05 1.10 1.20 1.30
	do
		EXPERIMENT_SUBNAME="inw${NN_INITIAL_NUM_OF_IN_WEIGHTS}_at${NN_ACTIVATION_THRESHOLD}_hut${NN_HABITUATION_UPDATE_TAU_WINNING_NEURON}_hua${NN_HABITUATION_UPDATE_ALPHA}"
		runExperiment50
	done
done

echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> EXPERIMENT $EXPERIMENT_NAME ENDED "
echo ""
