MY_DIR=`dirname $0`

source $MY_DIR/_setupExperiment.sh
EXPERIMENT_NAME="s1_x1_room";
ARGOS_FILE_NAME="experiments/s1_room.argos";
ENV_NUM_OF_LEARNING_LOOPS_BEFORE_CHANGE=20;
RUN_TIME=2000;	# 1 run through the room is approx. 50s -> leave 20 runs to stabilise, then do another 20 runs so total is 40*50


echo ""
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> EXPERIMENT $EXPERIMENT_NAME STARTED "

#---- best performing from input weights vs activation threshold experiment:
NN_INITIAL_NUM_OF_IN_WEIGHTS=9
NN_ACTIVATION_THRESHOLD=0.7

for NN_HABITUATION_THRESHOLD in 0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.40 0.50 0.60 0.70 0.80 0.90 1.00
do
	EXPERIMENT_SUBNAME="inw${NN_INITIAL_NUM_OF_IN_WEIGHTS}_at${NN_ACTIVATION_THRESHOLD}_ht${NN_HABITUATION_THRESHOLD}"
	runExperiment50
done

#----
NN_INITIAL_NUM_OF_IN_WEIGHTS=30
NN_ACTIVATION_THRESHOLD=0.2

for NN_HABITUATION_THRESHOLD in 0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.40 0.50 0.60 0.70 0.80 0.90 1.00
do
	EXPERIMENT_SUBNAME="inw${NN_INITIAL_NUM_OF_IN_WEIGHTS}_at${NN_ACTIVATION_THRESHOLD}_ht${NN_HABITUATION_THRESHOLD}"
	runExperiment50
done

#---- adaptive inw, best performing
NN_INITIAL_NUM_OF_IN_WEIGHTS=3;
NN_USE_ADAPTIVE_IN_WEIGHT_NUMBER="true";
NN_ACTIVATION_THRESHOLD=0.2

for NN_HABITUATION_THRESHOLD in 0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.40 0.50 0.60 0.70 0.80 0.90 1.00
do
	EXPERIMENT_SUBNAME="inwAdaptive_at${NN_ACTIVATION_THRESHOLD}_ht${NN_HABITUATION_THRESHOLD}"
	runExperiment50
done

NN_USE_ADAPTIVE_IN_WEIGHT_NUMBER="false";


#---- worst performing from input weights vs activation threshold experiment:
NN_INITIAL_NUM_OF_IN_WEIGHTS=21
NN_ACTIVATION_THRESHOLD=0.7

for NN_HABITUATION_THRESHOLD in 0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.40 0.50 0.60 0.70 0.80 0.90 1.00
do
	EXPERIMENT_SUBNAME="inw${NN_INITIAL_NUM_OF_IN_WEIGHTS}_at${NN_ACTIVATION_THRESHOLD}_ht${NN_HABITUATION_THRESHOLD}"
	#runExperiment50
done

NN_INITIAL_NUM_OF_IN_WEIGHTS=9
NN_ACTIVATION_THRESHOLD=0.3

for NN_HABITUATION_THRESHOLD in 0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.40 0.50 0.60 0.70 0.80 0.90 1.00
do
	EXPERIMENT_SUBNAME="inw${NN_INITIAL_NUM_OF_IN_WEIGHTS}_at${NN_ACTIVATION_THRESHOLD}_ht${NN_HABITUATION_THRESHOLD}"
	#runExperiment50
done


echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> EXPERIMENT $EXPERIMENT_NAME ENDED "
echo ""
