MY_DIR=`dirname $0`

source $MY_DIR/_setupExperiment.sh
EXPERIMENT_NAME="s1_x1_room";
ARGOS_FILE_NAME="experiments/s1_room.argos";
ENV_NUM_OF_LEARNING_LOOPS_BEFORE_CHANGE=20;
RUN_TIME=2000;	# 1 run through the room is approx. 50s -> leave 20 runs to stabilise, then do another 20 runs so total is 40*50


echo ""
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> EXPERIMENT $EXPERIMENT_NAME STARTED "

NN_HABITUATION_THRESHOLD=0.15;

#-- non-adaptive INW
for NN_INITIAL_NUM_OF_IN_WEIGHTS in 9 12 18 24 36 39 60 84 30  # robot considers N/3 num of closest blobs
do
	for NN_ACTIVATION_THRESHOLD in 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9
	do
		EXPERIMENT_SUBNAME="inw${NN_INITIAL_NUM_OF_IN_WEIGHTS}_at${NN_ACTIVATION_THRESHOLD}"
		runExperiment50
	done
done


#-- adaptive INW
NN_INITIAL_NUM_OF_IN_WEIGHTS=3;
NN_USE_ADAPTIVE_IN_WEIGHT_NUMBER="true";

for NN_ACTIVATION_THRESHOLD in 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9
do
	EXPERIMENT_SUBNAME="inwAdaptive_at${NN_ACTIVATION_THRESHOLD}"
	runExperiment50
done


echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> EXPERIMENT $EXPERIMENT_NAME ENDED "
echo ""
