MY_DIR=`dirname $0`

source $MY_DIR/_setupExperiment.sh
EXPERIMENT_NAME="s1_x2_corridor";
ARGOS_FILE_NAME="experiments/s1_corridor.argos";
ENV_NUM_OF_LEARNING_LOOPS_BEFORE_CHANGE=40;
RUN_TIME=4000;	# 1 run through the room is approx. 50s -> leave 40 runs to stabilise, then do another 40 runs so total is 80*50

echo ""
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> EXPERIMENT $EXPERIMENT_NAME STARTED "

#---- best performing non-adaptive with low INW
NN_INITIAL_NUM_OF_IN_WEIGHTS=12
NN_ACTIVATION_THRESHOLD=0.8

for ROBOT_BLOB_CAMERA_NOIZE_STD_DEV in 0.010 0.025 0.050 0.100 0.150 0.200 0.300 0.400
do
	EXPERIMENT_SUBNAME="inw${NN_INITIAL_NUM_OF_IN_WEIGHTS}_at${NN_ACTIVATION_THRESHOLD}_rms${ROBOT_MAX_SPEED}_bcn${ROBOT_BLOB_CAMERA_NOIZE_STD_DEV}"
	runExperiment50
done

#---- best performing non-adaptive with high INW
NN_INITIAL_NUM_OF_IN_WEIGHTS=39
NN_ACTIVATION_THRESHOLD=0.2

for ROBOT_BLOB_CAMERA_NOIZE_STD_DEV in 0.010 0.025 0.050 0.100 0.150 0.200 0.300 0.400
do
	EXPERIMENT_SUBNAME="inw${NN_INITIAL_NUM_OF_IN_WEIGHTS}_at${NN_ACTIVATION_THRESHOLD}_rms${ROBOT_MAX_SPEED}_bcn${ROBOT_BLOB_CAMERA_NOIZE_STD_DEV}"
	runExperiment50
done


#---- best performing adaptive
NN_INITIAL_NUM_OF_IN_WEIGHTS=3;
NN_USE_ADAPTIVE_IN_WEIGHT_NUMBER="true";
NN_ACTIVATION_THRESHOLD=0.2

for ROBOT_BLOB_CAMERA_NOIZE_STD_DEV in 0.010 0.025 0.050 0.100 0.150 0.200 0.300 0.400
do
	EXPERIMENT_SUBNAME="inwAdaptive_at${NN_ACTIVATION_THRESHOLD}_rms${ROBOT_MAX_SPEED}_bcn${ROBOT_BLOB_CAMERA_NOIZE_STD_DEV}"
	runExperiment50
done

NN_USE_ADAPTIVE_IN_WEIGHT_NUMBER="false";


echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> EXPERIMENT $EXPERIMENT_NAME ENDED "
echo ""
