MY_DIR=`dirname $0`

source $MY_DIR/_setupExperiment.sh
EXPERIMENT_NAME="s1_x2_room";
ARGOS_FILE_NAME="experiments/s1_room.argos";
ENV_NUM_OF_LEARNING_LOOPS_BEFORE_CHANGE=20;

echo ""
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> EXPERIMENT $EXPERIMENT_NAME STARTED "

NN_HABITUATION_THRESHOLD=0.15

#-- set robot speed to a very small one
ROBOT_MAX_SPEED=5
RUN_TIME=$( printf "%s\n " "scale = 2; (40*10*1.0)/($ROBOT_MAX_SPEED/100.0)" | bc)

for NN_INITIAL_NUM_OF_IN_WEIGHTS in 9 12 18 24 36 39 60 84 30  # robot considers N/3 num of closest blobs
do
	for NN_ACTIVATION_THRESHOLD in 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9
	do
		if [ ${NN_HABITUATION_THRESHOLD} == 0.3 ]; then
			EXPERIMENT_SUBNAME="inw${NN_INITIAL_NUM_OF_IN_WEIGHTS}_at${NN_ACTIVATION_THRESHOLD}_rms${ROBOT_MAX_SPEED}"
		else
			EXPERIMENT_SUBNAME="inw${NN_INITIAL_NUM_OF_IN_WEIGHTS}_at${NN_ACTIVATION_THRESHOLD}_rms${ROBOT_MAX_SPEED}_ht0.15"
		fi
		runExperiment50
	done
done


#-- adaptive INW
NN_INITIAL_NUM_OF_IN_WEIGHTS=3;
NN_USE_ADAPTIVE_IN_WEIGHT_NUMBER="true";

for NN_ACTIVATION_THRESHOLD in 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9
do
	if [ ${NN_HABITUATION_THRESHOLD} == 0.3 ]; then
		EXPERIMENT_SUBNAME="inwAdaptive_at${NN_ACTIVATION_THRESHOLD}_rms${ROBOT_MAX_SPEED}"
	else
		EXPERIMENT_SUBNAME="inwAdaptive_at${NN_ACTIVATION_THRESHOLD}_rms${ROBOT_MAX_SPEED}_ht0.15"
	fi
	runExperiment50
done


echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> EXPERIMENT $EXPERIMENT_NAME ENDED "
echo ""
