MY_DIR=`dirname $0`

source $MY_DIR/_setupExperiment.sh
EXPERIMENT_NAME="s1_x2_room";
ARGOS_FILE_NAME="experiments/s1_room.argos";
ENV_NUM_OF_LEARNING_LOOPS_BEFORE_CHANGE=20;

echo ""
echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> EXPERIMENT $EXPERIMENT_NAME STARTED "

#---- best performing non-adaptive with low INW
NN_INITIAL_NUM_OF_IN_WEIGHTS=9
NN_ACTIVATION_THRESHOLD=0.7

for ROBOT_MAX_SPEED in 5 10 15 20 25 30 40 60 80
do
	# calculate run time by mulitplying the number of passes (40) by number of meters in 1 pass (10) and diving that by robot speed in m/s 
	RUN_TIME=$( printf "%s\n " "scale = 2; (40*10*1.0)/($ROBOT_MAX_SPEED/100.0)" | bc)
	EXPERIMENT_SUBNAME="inw${NN_INITIAL_NUM_OF_IN_WEIGHTS}_at${NN_ACTIVATION_THRESHOLD}_rms${ROBOT_MAX_SPEED}"
	runExperiment50
done

#---- best performing non-adaptive with high INW
NN_INITIAL_NUM_OF_IN_WEIGHTS=30
NN_ACTIVATION_THRESHOLD=0.2

for ROBOT_MAX_SPEED in 5 10 15 20 25 30 40 60 80
do
	# calculate run time by mulitplying the number of passes (40) by number of meters in 1 pass (10) and diving that by robot speed in m/s 
	RUN_TIME=$( printf "%s\n " "scale = 2; (40*10*1.0)/($ROBOT_MAX_SPEED/100.0)" | bc)
	EXPERIMENT_SUBNAME="inw${NN_INITIAL_NUM_OF_IN_WEIGHTS}_at${NN_ACTIVATION_THRESHOLD}_rms${ROBOT_MAX_SPEED}"
	runExperiment50
done


#---- best performing adaptive
NN_INITIAL_NUM_OF_IN_WEIGHTS=3;
NN_USE_ADAPTIVE_IN_WEIGHT_NUMBER="true";
NN_ACTIVATION_THRESHOLD=0.2

for ROBOT_MAX_SPEED in 5 10 15 20 25 30 40 60 80
do
	# calculate run time by mulitplying the number of passes (40) by number of meters in 1 pass (10) and diving that by robot speed in m/s 
	RUN_TIME=$( printf "%s\n " "scale = 2; (40*10*1.0)/($ROBOT_MAX_SPEED/100.0)" | bc)
	EXPERIMENT_SUBNAME="inwAdaptive_at${NN_ACTIVATION_THRESHOLD}_rms${ROBOT_MAX_SPEED}"
	runExperiment50
done

NN_USE_ADAPTIVE_IN_WEIGHT_NUMBER="false";


echo ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> EXPERIMENT $EXPERIMENT_NAME ENDED "
echo ""
