/* ================================================================
 * ================================================================
 *
 * Represents an event that gets fired during the simulation.
 * Used both in the simulation and in the data analysis code.
 *
 * Author: L. Pitonakova (http://lenkaspace.net)
 * License: GNU General Public License. Please credit me when using my work.
 *
 * ================================================================
 * ================================================================
 */

#ifndef COMMON_EVENT_H
#define COMMON_EVENT_H

#include <argos3/core/utility/math/vector3.h>

class Event {
public:

   enum TYPE {
      UNKNOWN = 0,
      ENV_CHANGED,
      NN_CHANGED,
      ROBOT_TELEPORTED,
      ROBOT_REACHED_WAYPOINT
   };

   Event() {
      type = Event::TYPE::UNKNOWN;
      time = -1;
      objectId = -1;
      position = argos::CVector3();
      numOfNeurons = -1;
      numOfConnections = -1;
      numOfInWeights = -1;
   }

   /**
    * Constructor for events with a location, i.e. of type ENV_CHANGED and ROBOT_TELEPORTED
    */
   Event(Event::TYPE type_, int time_, int objectId_, argos::CVector3 position_) {
      type = type_;
      time = time_;
      objectId = objectId_;
      position = argos::CVector3(position_);
      waypointId = "";
      numOfNeurons = -1;
      numOfConnections = -1;
      numOfInWeights = -1;
   }

   /**
    * Constructor for events with a location and string, i.e. of type ROBOT_REACHED_WAYPOINT
    */
   Event(Event::TYPE type_, int time_, int objectId_, argos::CVector3 position_, std::string waypointId_) {
      type = type_;
      time = time_;
      objectId = objectId_;
      position = argos::CVector3(position_);
      waypointId = waypointId_;
      numOfNeurons = -1;
      numOfConnections = -1;
      numOfInWeights = -1;
   }

   /**
    * Constructor for events of type NN_CHANGED
    */
   Event(Event::TYPE type_, int time_, int objectId_, int numOfNeurons_, int numOfInWeights_, int numOfConnections_ ) {
      type = type_;
      time = time_;
      objectId = objectId_;
      position = argos::CVector3();
      waypointId = "";
      numOfNeurons = numOfNeurons_;
      numOfConnections = numOfConnections_;
      numOfInWeights = numOfInWeights_;
   }


   virtual ~Event() {}

   Event::TYPE type;
   argos::CVector3 position;
   int objectId;
   int time;
   int numOfNeurons;
   int numOfConnections;
   int numOfInWeights;
   std::string waypointId;



};


#endif
